﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using MicroRWD.Common;
using MicroRWD.MFIC;

namespace MicroRWD.UI.MFIC
{
    public partial class DataPanel : UserControl
    {
        // Active Tab change event handler
        private event ActiveTabEventHandler activeTabEvent;
        public event ActiveTabEventHandler ActiveTabEvent { add { activeTabEvent += value; } remove { activeTabEvent -= value; } }

        public DataPanel()
        {
            InitializeComponent();
            mifareTabPanel1.Parent1 = this;
            icodeTabPanel1.Parent1 = this;
        }

        public void SetVisible(bool _visible, ViewMode _tab)
        {
            Visible = _visible;

            if (_visible)
            {
                //Update view(s)
                UpdateCardPage(_tab);
                UpdatePictureBox();
            }
        }

        // Fire status update event to listeners
        public void FireActiveTabEvent(ViewMode _viewMode)
        {
            try
            {
                // Instantiate suitable event args object
                ActiveTabEventArgs args = new ActiveTabEventArgs(_viewMode);

                // Check for current listeners
                if (activeTabEvent != null)
                {
                    // Dispatch event to listeners
                    activeTabEvent(this, args);
                }
            }
            catch (Exception ex)
            {
                Log.Error(ex.ToString());
            }
        }

        
        #region Private Methods

        // Update card page depending on mode
        private void UpdateCardPage(ViewMode _tab)
        {
            // Card
            switch (Program.Controller.Reader.Mode)
            {
                case Mode.MIFARE:
                    mifareTabPanel1.Visible = true;
                    mifareTabPanel1.Tab = _tab;
                    icodeTabPanel1.Visible = false;
                    break;

                case Mode.ICODE:
                    mifareTabPanel1.Visible = false;
                    icodeTabPanel1.Visible = true;
                    icodeTabPanel1.Tab = _tab;
                    break;

                default:
                    mifareTabPanel1.Visible = false;
                    icodeTabPanel1.Visible = false;
                    break;
            }
        }

        // Update picture box depending on mode and tab select
        private void UpdatePictureBox()
        {
            // Set the correct image to match the active tab
            if(Program.Controller.Reader.Mode == Mode.MIFARE)
            {
                switch (this.mifareTabPanel1.MifareTabControl.SelectedIndex)
                {
                    case 0:
                        this.pictureBox.Image = global::MicroRWD.UI.MFIC.Properties.Resources.mifareCard;
                        break;

                    case 1:
                        this.pictureBox.Image = global::MicroRWD.UI.MFIC.Properties.Resources.MicroRWDKeys;
                        break;

                    case 2:
                        this.pictureBox.Image = global::MicroRWD.UI.MFIC.Properties.Resources.MicroRWDBinary;
                        break;
                }

            }
            else if (Program.Controller.Reader.Mode == Mode.ICODE)
            {
                switch (this.icodeTabPanel1.IcodeTabControl.SelectedIndex)
                {
                    case 0:
                        this.pictureBox.Image = global::MicroRWD.UI.MFIC.Properties.Resources.IcodeCard;
                        break;

                    case 1:
                        this.pictureBox.Image = global::MicroRWD.UI.MFIC.Properties.Resources.MicroRWDBinary;
                        break;

                }
            }
            else
            {
                pictureBox.Image = null;
            }
        }

        #endregion

        #region Event Handlers

        private void exitButton_Click(object sender, EventArgs e)
        {
            Program.Controller.Exit();
        }

        private void DataPanel_Load(object sender, EventArgs e)
        {
            // Subscribe to the tab control events
            this.icodeTabPanel1.IcodeTabControl.SelectedIndexChanged += new System.EventHandler(this.icodeTabControl_SelectedIndexChanged);
            this.mifareTabPanel1.MifareTabControl.SelectedIndexChanged += new System.EventHandler(this.mifareTabControl_SelectedIndexChanged);
            
            // Update view(s) unless in design mode
            if (!DesignMode && (Program.Controller != null))
            {
                // Update view(s)
                UpdateCardPage(ViewMode.NONE);
                UpdatePictureBox();
            }
        }

        private void icodeTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdatePictureBox();
        }

        private void mifareTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            UpdatePictureBox();
        }

        #endregion
    }
}
